#! /bin/sh
source /koolshare/scripts/base.sh
alias echo_date='echo 【$(TZ=UTC-8 date -R +%Y年%m月%d日\ %X)】:'
mkdir -p /tmp/upload

Get_Router_Model() {
		local HARDWARE_MODEL
		[ -z "$(nvram get odmpid)" ] && HARDWARE_MODEL=$(nvram get productid) || HARDWARE_MODEL=$(nvram get odmpid)
		echo $HARDWARE_MODEL
		return 0
}

echo_date 清理旧文件
rm -rf /koolshare/scripts/n2oplugin
rm -rf /koolshare/scripts/game.sh
rm -rf /koolshare/scripts/enc_abc

rm -rf /koolshare/webs/Module_N2O.asp
rm -rf /koolshare/res/icon-N2O.png

[ -f "/koolshare/bin/acc-g1" ] && rm -rf /koolshare/bin/acc-g1
[ -f "/koolshare/bin/acc-g2" ] && rm -rf /koolshare/bin/acc-g2
[ -f "/koolshare/bin/opv" ] && rm -rf /koolshare/bin/opv
[ -f "/koolshare/bin/m4_enc" ] && rm -rf /koolshare/bin/m4_enc
rm -rf /koolshare/bin/pdu
rm -rf /koolshare/bin/nn_status.bin
rm -rf /koolshare/bin/u2_enc
#[ -f "/koolshare/bin/ph-aarch64-enc" ] && rm -rf /koolshare/bin/ph-aarch64-enc
#[ -f "/koolshare/bin/ph-v7-enc" ] && rm -rf /koolshare/bin/ph-v7-enc

#RT-AC86U需要增加虚拟内存
IsAc86u=`nvram get model |grep AC86U |grep -v grep | wc -l`
IsSda=`df -h |grep /dev/sda1 |grep -v grep | wc -l`
if [ $IsAc86u -eq 0  ]; then
    #echo_date 设备不是Ac86u，程序安装到jffs分区
    mkdir /jffs/opt
    ln -nsf /jffs/opt /tmp/opt
    touch /jffs/scripts/post-mount
    cat > /jffs/scripts/post-mount <<EOF
#!/bin/sh
sleep 10
ln -nsf /jffs/opt /tmp/opt
EOF
    chmod a+rx /jffs/scripts/post-mount
else
    if [ $IsSda -ne 0  ]; then
	    echo_date 设备是Ac86u，已挂载虚拟内存，程序安装到/dev/sda1中
        mkdir /tmp/opt
        mount /dev/sda1 /tmp/opt
        touch /jffs/scripts/mountOpt
        cat > /jffs/scripts/mountOpt <<EOF
#!/bin/sh
mkdir /tmp/opt
mount /dev/sda1 /tmp/opt
EOF
        chmod a+rx /jffs/scripts/mountOpt
        nvram set script_usbmount="/jffs/scripts/mountOpt"
        nvram commit
	else
	    echo_date 设备是ac86u，但未挂载虚拟内存，程序安装到jffs分区
	    mkdir /jffs/opt
        ln -nsf /jffs/opt /tmp/opt
        touch /jffs/scripts/post-mount
        cat > /jffs/scripts/post-mount <<EOF
#!/bin/sh
sleep 10
ln -nsf /jffs/opt /tmp/opt
EOF
        chmod a+rx /jffs/scripts/post-mount
    fi		
fi

echo_date 开始复制文件

HARDWARE_MODEL=$(Get_Router_Model)

cp -rf /tmp/N2O/bin/*     /koolshare/bin/

cp -rf /tmp/N2O/scripts/* /koolshare/scripts/
cp -rf /tmp/N2O/uninstall.sh /koolshare/scripts/uninstall_N2O.sh
cp -rf /tmp/N2O/webs/* /koolshare/webs/
cp -rf /tmp/N2O/res/* /koolshare/res/


chmod 777  /koolshare/scripts/n2oplugin
chmod 777 /koolshare/scripts/game.sh
chmod 777  /koolshare/scripts/enc_abc

chmod 777  /koolshare/bin/m4_enc
chmod 777  /koolshare/bin/pdu
chmod 777  /koolshare/bin/nn_status.bin
chmod 777  /koolshare/bin/u2_enc

case "$HARDWARE_MODEL" in
	RT-BE88U|RT-BE86U|RT-BE96U|GT-BE98)
		sed -i 's#<script type="text/javascript" language="JavaScript" src="/client_function.js"></script>#<!-- <script type="text/javascript" language="JavaScript" src="/client_function.js"></script> -->#' /koolshare/webs/Module_N2O.asp
		;;
	*)	
		echo_date 设备型号是: $HARDWARE_MODEL
		;;
esac


rm -rf /tmp/N2O* >/dev/null 2>&1

echo_date 安装成功！
